--Loadouts database
-------------------------------------------------------------------------------------------------------

--[[ Loadout Entry Example ----------------------------------------------------------------------------

["MiG-21Bis"] = {														--String, aircraft type
	["Strike"] = {														--String, task
		["Custom Loadout Name"] = {										--String, custom loadout name
			support = {													--Table, list of tasks that can support this loadout (nil = is never added, true = is added when available)
				["Escort"] = true,										--Fighter escort
				["SEAD"] = true,										--SEAD	escort
				["Escort Jammer"] = true,								--Jammer escort
				["Flare Illumination"] = true,							--Target area flare illumination (mandatory support for loadout to be eligible)
				["Laser Illumination"] = true,							--Target laser illumination (mandatory support for loadout to be eligible)
			},
			attributes = {												--Array, custom loadout attributes. Only used by A-G tasks. Any target attribute must be matched in this array for the loadout to be eligible for the target.
				[1] = "Anti-tank",										--String, custom attribute to be matched for target attribute
				[2] = "Stand-off Missile",								--String, custom attribute to be matched for target attribute
			},
			weaponType = "Bombs",										--String, type of ordinance of loadout. Only used by A-G taks. Options: "Cannon", "Rockets", "Bombs", "Guided bombs", "ASM". A-G weapon types cannot be mixed.
			expend = "All",												--String, quantity of wapons expended per attack. Only used by A-G tasks. Options: "Auto", "All", "Half", "Two".
			day = true,													--Boolean, loadout is day capable
			night = false,												--Boolean, loadout is night capable
			adverseWeather = true,										--Boolean, loadout is adverse weather capable
			range = 900000,												--Number, range radius in meters
			capability = 1,											--Number, how good is the aircraft with this loadout. The higher the better
			firepower = 1,												--Number, how much firepower has this loadout. The higher the better
			vCruise = 225,												--Number, cruise speed in m/s
			vAttack = 280,												--Number, attack speed in m/s
			hCruise = 6000,												--Number, cruise altitude in m
			hAttack = 100,												--Number, attack altitude in m
			standoff = 5000,											--Number, attack distance from target in m. Determines attack waypoint distance for A-G with missiles (for Bombss use nil) and engage distance for A-A tasks
			tStation = 1200,											--Number, seconds the aircraft can remain on station. Only used by CAP, AWACS and Refuelling tasks
			LDSD = true,												--Boolean, aircraft is Look-Down/Shoot-Down capable. Only used by CAP and Intercept tasks
			--- self_escort = false,										--Boolean, aircraft can defend itself against fighters. Only used by A-G tasks
			sortie_rate = 2,											--Number, average amount of sorties that aircraft flies per day
			stores = {													--Table, loadout table for DCS
				["pylons"] = 
				{
					[1] = 
					{
						["CLSID"] = "{R-60M 2L}",
					},
					[2] = 
					{
						["CLSID"] = "{R-3R}",
					},
					[3] = 
					{
						["CLSID"] = "{PTB_800_MIG21}",
					},
					[4] = 
					{
						["CLSID"] = "{R-3R}",
					},
					[5] = 
					{
						["CLSID"] = "{R-60M 2R}",
					},
					[6] = 
					{
						["CLSID"] = "{ASO-2}",
					},
				},
				["fuel"] = 2280,
				["flare"] = 32,
				["ammo_type"] = 1,
				["chaff"] = 32,
				["gun"] = 100,
			},
		},
	},
},

]]-----------------------------------------------------------------------------------------------------


db_loadouts = {
	["MiG-21Bis"] = {
		["Intercept"] = {
			["GTA AIR/AIR ,R60*4 R3R*2,FT 800L"] = {
				attributes = {},
				weaponType = nil,
				expend = nil,
				day = true,
				night = false,
				adverseWeather = true,
				range = 600000,
				capability = 5,
				firepower = 1,
				vCruise = nil,
				vAttack = nil,
				hCruise = nil,
				hAttack = nil,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 10,
				stores = {
			["pylons"] = {
				[3] = {
					["CLSID"] = "{PTB_800_MIG21}",
					["num"] = 3,
				},
				[2] = {
					["CLSID"] = "{R-3R}",
					["num"] = 2,
				},
				[4] = {
					["CLSID"] = "{R-3R}",
					["num"] = 4,
				},
				[1] = {
					["CLSID"] = "{R-60 2L}",
					["num"] = 1,
				},
				[5] = {
					["CLSID"] = "{R-60 2R}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "{ASO-2}",
					["num"] = 6,
				},
			}, -- end of ["pylons"]
					["fuel"] = 2280,
					["flare"] = 40,
					["chaff"] = 18,
					["gun"] = 100,
				},
			},
		},
		["CAP"] = {
			["GTA AIR/AIR Medium,R60*4 R3R*2,FT 800L"] = {
				attributes = {"medium"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = false,
				adverseWeather = true,
				range = 600000,
				capability = 5,
				firepower = 1,
				vCruise = 200,
				vAttack = 220,
				hCruise = 4000,
				hAttack = 4200,
				standoff = 15000,
				tStation = 2400,
				LDSD = false,
				self_escort = false,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[3] = {
					["CLSID"] = "{PTB_800_MIG21}",
					["num"] = 3,
				},
				[2] = {
					["CLSID"] = "{R-3R}",
					["num"] = 2,
				},
				[4] = {
					["CLSID"] = "{R-3R}",
					["num"] = 4,
				},
				[1] = {
					["CLSID"] = "{R-60 2L}",
					["num"] = 1,
				},
				[5] = {
					["CLSID"] = "{R-60 2R}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "{ASO-2}",
					["num"] = 6,
				},
			}, -- end of ["pylons"]
					["fuel"] = 2280,
					["flare"] = 40,
					["chaff"] = 18,
					["gun"] = 100,
				},
			},
			["GTA AIR/AIR Low,R60*4 R3R*2,FT 800L"] = {
				attributes = {"low"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = false,
				adverseWeather = true,
				range = 600000,
				capability = 5,
				firepower = 1,
				vCruise = 200,
				vAttack = 220,
				hCruise = 2000,
				hAttack = 2000,
				standoff = 15000,
				tStation = 1800,
				LDSD = false,
				self_escort = false,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[3] = {
					["CLSID"] = "{PTB_800_MIG21}",
					["num"] = 3,
				},
				[2] = {
					["CLSID"] = "{R-3R}",
					["num"] = 2,
				},
				[4] = {
					["CLSID"] = "{R-3R}",
					["num"] = 4,
				},
				[1] = {
					["CLSID"] = "{R-60 2L}",
					["num"] = 1,
				},
				[5] = {
					["CLSID"] = "{R-60 2R}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "{ASO-2}",
					["num"] = 6,
				},
			}, -- end of ["pylons"]
					["fuel"] = 2280,
					["flare"] = 40,
					["chaff"] = 18,
					["gun"] = 100,
				},
			},
		},	
		["Escort"] = {
			["GTA AIR/AIR ,R60*4 R3R*2,FT 800L"] = {
				attributes = {},
				weaponType = nil,
				expend = nil,
				day = true,
				night = false,
				adverseWeather = true,
				range = 700000,
				capability = 5,
				firepower = 1,
				vCruise = 250,
				-- vAttack = 350,
				-- hCruise = 7500,
				-- hAttack = 5500,
				standoff = 10000,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[3] = {
					["CLSID"] = "{PTB_800_MIG21}",
					["num"] = 3,
				},
				[2] = {
					["CLSID"] = "{R-3R}",
					["num"] = 2,
				},
				[4] = {
					["CLSID"] = "{R-3R}",
					["num"] = 4,
				},
				[1] = {
					["CLSID"] = "{R-60 2L}",
					["num"] = 1,
				},
				[5] = {
					["CLSID"] = "{R-60 2R}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "{ASO-2}",
					["num"] = 6,
				},
			}, -- end of ["pylons"]
					["fuel"] = 2280,
					["flare"] = 40,
					["chaff"] = 18,
					["gun"] = 100,
				},
			},
		},
		["Fighter Sweep"] = {
			["GTA AIR/AIR ,R60*4 R3R*2,FT 800L"] = {
				attributes = {},
				weaponType = nil,
				expend = nil,
				day = true,
				night = false,
				adverseWeather = true,
				range = 700000,
				capability = 5,
				firepower = 1,
				vCruise = 225,
				vAttack = 250,
				hCruise = 7500,
				hAttack = 5500,
				standoff = 20000,
				tStation = nil,
				LDSD = false,
				self_escort = true,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[3] = {
					["CLSID"] = "{PTB_800_MIG21}",
					["num"] = 3,
				},
				[2] = {
					["CLSID"] = "{R-3R}",
					["num"] = 2,
				},
				[4] = {
					["CLSID"] = "{R-3R}",
					["num"] = 4,
				},
				[1] = {
					["CLSID"] = "{R-60 2L}",
					["num"] = 1,
				},
				[5] = {
					["CLSID"] = "{R-60 2R}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "{ASO-2}",
					["num"] = 6,
				},
			}, -- end of ["pylons"]
					["fuel"] = 2280,
					["flare"] = 40,
					["chaff"] = 18,
					["gun"] = 100,
				},
			},
		},
		["Strike"] = {
			["GTA strike 2  GROM*2  FT800L"] = {
				minscore = 0.3,
				support = {
						["Escort"] = true,
						["SEAD"] = false,
					},
				attributes = {"soft", "Parked Aircraft", "Structure", "Bridge", "SAM"},
				weaponType = "ASM",
				expend = "Auto",
				attackType = nil,
				day = true,
				night = false,
				adverseWeather = true,
				range = 700000,
				capability = 1,
				firepower = 1,
				vCruise = 200,
				vAttack = 250,
				hCruise = 3500,
				hAttack = 3000,
				standoff = 2000,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
				[1] = {
					["CLSID"] = "{R-60 2L}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{Kh-66_Grom}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{PTB_800_MIG21}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{Kh-66_Grom}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{R-60 2R}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "{ASO-2}",
					["num"] = 6,
				},
			}, -- end of ["pylons"]
                ["fuel"] = 2280,
				["flare"] = 40,
				["chaff"] = 18,
				["gun"] = 100,
				},
			},
			["GTA strike 1 S24*4 FT800L"] = {
				minscore = 0.3,
				support = {
						["Escort"] = true,
						["SEAD"] = false,
					},
				attributes = {"soft", "Parked Aircraft", "Structure", "SAM"},
				weaponType = "Rockets",
				expend = "All",
				attackType = nil,
				day = true,
				night = false,
				adverseWeather = true,
				range = 700000,
				capability = 1,
				firepower = 1,
				vCruise = 200,
				vAttack = 250,
				hCruise = 1500,
				hAttack = 1000,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 8,
				stores = {
				["pylons"] = {
				[3] = {
					["CLSID"] = "{PTB_800_MIG21}",
					["num"] = 3,
				},
				[1] = {
					["CLSID"] = "{S-24A}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{S-24A}",
					["num"] = 2,
				},
				[4] = {
					["CLSID"] = "{S-24A}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{S-24A}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "{ASO-2}",
					["num"] = 6,
				},
			}, -- end of ["pylons"]
                ["fuel"] = 2280,
				["flare"] = 40,
				["chaff"] = 18,
				["gun"] = 100,
				},
			},
		},		
	},
	["MiG-27K"] = {
		["Strike"] = {
			["GTA STRIKE1 Kh-29L*2,R-60M*2,Fuel"] = {
			minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = false,
					["Laser Illumination"] = false,
				},
				attributes = {"soft", "Parked Aircraft", "Structure", "SAM"},
				weaponType = "ASM",
				expend = "Auto",
				day = true,
				night = false,
				adverseWeather = true,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 215.83333333333,
				vAttack = 277.5,
				hCruise = 5315.2,
				hAttack = 2000,
				standoff = 2000,
				tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[2] = {
					["CLSID"] = "{D4A8D9B9-5C45-42e7-BBD2-0E54F8308432}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
					["num"] = 3,
				},
				[5] = {
					["CLSID"] = "{A5BAEAB7-6FAF-4236-AF72-0FD900F493F9}",
					["num"] = 5,
				},
				[7] = {
					["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
					["num"] = 7,
				},
				[8] = {
					["CLSID"] = "{D4A8D9B9-5C45-42e7-BBD2-0E54F8308432}",
					["num"] = 8,
				},
			}, -- end of ["pylons"]
				["fuel"] = "4500",
                ["flare"] = 60,
                ["chaff"] = 60,
                ["gun"] = 100,
				},
			},
			["GTA STRIKE2 Kh-25L*2,R-60M*2,Fuel"] = {
			minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = false,
					["Laser Illumination"] = false,
				},
				attributes = {"soft", "Parked Aircraft", "Structure", "SAM"},
				weaponType = "ASM",
				expend = "Auto",
				day = true,
				night = false,
				adverseWeather = true,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 215.83333333333,
				vAttack = 277.5,
				hCruise = 5924.8,
				hAttack = 2315.2,
				standoff = 2000,
				tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[2] = {
					["CLSID"] = "{79D73885-0801-45a9-917F-C90FE1CE3DFC}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
					["num"] = 3,
				},
				[5] = {
					["CLSID"] = "{A5BAEAB7-6FAF-4236-AF72-0FD900F493F9}",
					["num"] = 5,
				},
				[7] = {
					["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
					["num"] = 7,
				},
				[8] = {
					["CLSID"] = "{79D73885-0801-45a9-917F-C90FE1CE3DFC}",
					["num"] = 8,
				},
			}, -- end of ["pylons"]
				["fuel"] = "4500",
                ["flare"] = 60,
                ["chaff"] = 60,
                ["gun"] = 100,
				},
			},
			["GTA FAB-500*2,FAB-250*2,R-60M*2,Fuel"] = {
			minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = false,
					["Laser Illumination"] = false,
				},
				attributes = {"Bridge"},
				weaponType = "Bombs",
				expend = "All",
				day = true,
				night = false,
				adverseWeather = true,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 215.83333333333,
				vAttack = 277.5,
				hCruise = 5924.8,
				hAttack = 2315.2,
				standoff = nil,
				tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[2] = {
					["CLSID"] = "{37DCC01E-9E02-432F-B61D-10C166CA2798}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{A5BAEAB7-6FAF-4236-AF72-0FD900F493F9}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}",
					["num"] = 6,
				},
				[7] = {
					["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
					["num"] = 7,
				},
				[8] = {
					["CLSID"] = "{37DCC01E-9E02-432F-B61D-10C166CA2798}",
					["num"] = 8,
				},
			}, -- end of ["pylons"]
				["fuel"] = "4500",
                ["flare"] = 60,
                ["chaff"] = 60,
                ["gun"] = 100,
				},
			},
		},	
	},
	["F-5E-3"] = {
		["Strike"] = {
			["GTA CAS1/STRIKE Mk-82SE*4,AIM-9P*2,Fuel 275"] = {
			minscore = 0.1,
				support = {
					["Escort"] = true,
					["SEAD"] = false,
				},
				attributes = {"Bridge", "soft", "Parked Aircraft", "Structure", "SAM"},
				weaponType = "Bombs",
				expend = "All",
				day = true,
				night = false,
				adverseWeather = true,
				range = 360000,
				capability = 1,
				firepower = 1,
				vCruise = 215.83333333333,
				vAttack = 277.5,
				hCruise = 2486.4,
				hAttack = 2572,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = 
					{
				[1] = {
					["CLSID"] = "{9BFD8C90-F7AE-4e90-833B-BFD0CED0E536}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{Mk82SNAKEYE}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{Mk82SNAKEYE}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{0395076D-2F77-4420-9D33-087A4398130B}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{Mk82SNAKEYE}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "{Mk82SNAKEYE}",
					["num"] = 6,
				},
				[7] = {
					["CLSID"] = "{9BFD8C90-F7AE-4e90-833B-BFD0CED0E536}",
					["num"] = 7,
				}, -- end of [7]
					}, -- end of ["pylons"]
					["fuel"] = 2046,
					["flare"] = 15,
					["chaff"] = 30,
					["gun"] = 100,
				},
			},
			["GTA CAS2/STRIKE CBU-52B*4,AIM-9P*2,Fuel 275"] = {
			minscore = 0.1,
				support = {
					["Escort"] = false,
					["SEAD"] = false,
				},
				attributes = {"soft", "Parked Aircraft", "SAM"},
				weaponType = "Bombs",
				expend = "All",
				day = true,
				night = false,
				adverseWeather = false,
				range = 130000,
				capability = 1,
				firepower = 1,
				vCruise = 215.83333333333,
				vAttack = 277.5,
				hCruise = 2876.8,
				hAttack = 2572,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				self_escort = true,
				sortie_rate = 6,
				stores = {
					["pylons"] = 
					{
						[1] = {
				["CLSID"] = "{9BFD8C90-F7AE-4e90-833B-BFD0CED0E536}",
					["num"] = 1,
				},
				[4] = {
					["CLSID"] = "{0395076D-2F77-4420-9D33-087A4398130B}",
					["num"] = 4,
				},
				[7] = {
					["CLSID"] = "{9BFD8C90-F7AE-4e90-833B-BFD0CED0E536}",
					["num"] = 7,
				},
				[5] = {
					["CLSID"] = "{CBU-52B}",
					["num"] = 5,
				},
				[3] = {
					["CLSID"] = "{CBU-52B}",
					["num"] = 3,
				},
				[6] = {
					["CLSID"] = "{CBU-52B}",
					["num"] = 6,
				},
				[2] = {
					["CLSID"] = "{CBU-52B}",
					["num"] = 2,
				},
					}, -- end of ["pylons"]
					["fuel"] = 2046,
					["flare"] = 15,
					["chaff"] = 30,
					["gun"] = 100,
				},
			},
		},
	},
	["F-4E"] = {
		["Intercept"] = {
			["GTA AIR/AIR AIM-9*4,AIM-7*4"] = {
				attributes = {},
				weaponType = nil,
				expend = nil,
				day = true,
				night = false,
				adverseWeather = true,
				range = 400000,
				capability = 1,
				firepower = 1,
				-- vCruise = nil,
				-- vAttack = nil,
				-- hCruise = nil,
				-- hAttack = nil,
				-- standoff = nil,
				-- tStation = nil,
				LDSD = true,
				-- --- self_escort = true,
				sortie_rate = 10,
				stores = {
			["pylons"] = {
				[2] = {
					["CLSID"] = "{9DDF5297-94B9-42FC-A45E-6E316121CD85}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 4,
				},
				[6] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 6,
				},
				[7] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 7,
				},
				[8] = {
					["CLSID"] = "{9DDF5297-94B9-42FC-A45E-6E316121CD85}",
					["num"] = 8,
				},
			},
					["fuel"] = "4864",
					["flare"] = 30,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
		},
		["Escort"] = {
			["GTA AIR/AIR AIM-9*4,AIM-7*4"] = {
				attributes = {},
				weaponType = nil,
				expend = nil,
				day = true,
				night = false,
				adverseWeather = true,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 255.83333333333,
				-- vAttack = 265.83333333333,
				-- hCruise = 9753.6,
				-- hAttack = 9753.6,
				standoff = 46300,
				tStation = nil,
				LDSD = true,
				--- self_escort = true,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[2] = {
					["CLSID"] = "{9DDF5297-94B9-42FC-A45E-6E316121CD85}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 4,
				},
				[6] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 6,
				},
				[7] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 7,
				},
				[8] = {
					["CLSID"] = "{9DDF5297-94B9-42FC-A45E-6E316121CD85}",
					["num"] = 8,
				},
			},
					["fuel"] = "4864",
					["flare"] = 30,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
		},		
		["Fighter Sweep"] = {
			["GTA AIR/AIR AIM-9*4,AIM-7*4"] = {
				attributes = {},
				weaponType = nil,
				expend = nil,
				day = true,
				night = false,
				adverseWeather = true,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 255.83333333333,
				vAttack = 265.83333333333,
				hCruise = 2753.6,
				hAttack = 2753.6,
				standoff = 46300,
				tStation = nil,
				LDSD = true,
				--- self_escort = true,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[2] = {
					["CLSID"] = "{9DDF5297-94B9-42FC-A45E-6E316121CD85}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 4,
				},
				[6] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 6,
				},
				[7] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 7,
				},
				[8] = {
					["CLSID"] = "{9DDF5297-94B9-42FC-A45E-6E316121CD85}",
					["num"] = 8,
				},
			},
					["fuel"] = "4864",
					["flare"] = 30,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
		},
		["CAP"] = {
			["GTA AIR/AIR Medium AIM-9*4,AIM-7*4"] = {
				attributes = {"medium"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = false,
				adverseWeather = true,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 215.83333333333,
				vAttack = 246.66666666667,
				hCruise = 4000,
				hAttack = 4000,
				standoff = 36000,
				tStation = 1800,
				LDSD = true,
				--- self_escort = true,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[2] = {
					["CLSID"] = "{9DDF5297-94B9-42FC-A45E-6E316121CD85}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 4,
				},
				[6] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 6,
				},
				[7] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 7,
				},
				[8] = {
					["CLSID"] = "{9DDF5297-94B9-42FC-A45E-6E316121CD85}",
					["num"] = 8,
				},
			},
					["fuel"] = "4864",
					["flare"] = 30,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["GTA AIR/AIR Low AIM-9*4,AIM-7*4"] = {
				attributes = {"low"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = false,
				adverseWeather = true,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 215.83333333333,
				vAttack = 246.66666666667,
				hCruise = 2000,
				hAttack = 2000,
				standoff = 36000,
				tStation = 1800,
				LDSD = true,
				--- self_escort = true,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[2] = {
					["CLSID"] = "{9DDF5297-94B9-42FC-A45E-6E316121CD85}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 4,
				},
				[6] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 6,
				},
				[7] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 7,
				},
				[8] = {
					["CLSID"] = "{9DDF5297-94B9-42FC-A45E-6E316121CD85}",
					["num"] = 8,
				},
			},
					["fuel"] = "4864",
					["flare"] = 30,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
		},
		["Strike"] = {
			["GTA CAS1 AGM-65K*4,AIM-7*2,Fuel*2,ECM"] = {
			minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = false,
				},
				attributes = {"soft", "Parked Aircraft", "SAM"},
					weaponType = "ASM",
					expend = "Auto",
					day = true,
					night = false,
					adverseWeather = true,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 215.83333333333,
				vAttack = 277.5,
				hCruise = 3486.4,
				hAttack = 2572,
				standoff = 2000,
				tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
				[1] = {
					["CLSID"] = "{7B4B122D-C12C-4DB4-834E-4D8BB4D863A8}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{D7670BC7-881B-4094-906C-73879CF7EB28}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{6D21ECEA-F85B-4E8D-9D51-31DC9B8AA4EF}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 4,
				},
				[6] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 6,
				},
				[8] = {
					["CLSID"] = "{D7670BC7-881B-4094-906C-73879CF7EB27}",
					["num"] = 8,
				},
				[9] = {
					["CLSID"] = "{7B4B122D-C12C-4DB4-834E-4D8BB4D863A8}",
					["num"] = 9,
				},
				}, -- end of ["pylons"]
					["fuel"] = "4864",
					["flare"] = 30,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["GTA strike Mk-82*6,AIM-7*2,Fuel*2,ECM"] = {
			minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = false,
				},
				attributes = {"Bridge", "soft", "Parked Aircraft", "Structure", "SAM"},
					weaponType = "Bombs",
					expend = "All",
					day = true,
					night = false,
					adverseWeather = false,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 215.83333333333,
				vAttack = 277.5,
				hCruise = 3486.4,
				hAttack = 2572,
				standoff = nil,
				tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
					[1] = {
					["CLSID"] = "{7B4B122D-C12C-4DB4-834E-4D8BB4D863A8}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{60CC734F-0AFA-4E2E-82B8-93B941AB11CF}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{6D21ECEA-F85B-4E8D-9D51-31DC9B8AA4EF}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 4,
				},
				[6] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 6,
				},
				[8] = {
					["CLSID"] = "{60CC734F-0AFA-4E2E-82B8-93B941AB11CF}",
					["num"] = 8,
				},
				[9] = {
					["CLSID"] = "{7B4B122D-C12C-4DB4-834E-4D8BB4D863A8}",
					["num"] = 9,
				},
				}, -- end of ["pylons"]
					["fuel"] = "4864",
					["flare"] = 30,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["GTA CAS2 Mk20*6,AIM-7*2,Fuel*2,ECM"] = {
			minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = false,
				},
				attributes = {"soft", "Parked Aircraft", "SAM"},
				weaponType = "Bombs",
				expend = "All",
				day = true,
				night = false,
				adverseWeather = false,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 215.83333333333,
				vAttack = 277.5,
				hCruise = 3486.4,
				hAttack = 2572,
				standoff = nil,
				tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[1] = {
					["CLSID"] = "{7B4B122D-C12C-4DB4-834E-4D8BB4D863A8}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{B83CB620-5BBE-4BEA-910C-EB605A327EF9}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{6D21ECEA-F85B-4E8D-9D51-31DC9B8AA4EF}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 4,
				},
				[6] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 6,
				},
				[8] = {
					["CLSID"] = "{B83CB620-5BBE-4BEA-910C-EB605A327EF9}",
					["num"] = 8,
				},
				[9] = {
					["CLSID"] = "{7B4B122D-C12C-4DB4-834E-4D8BB4D863A8}",
					["num"] = 9,
				},
			}, -- end of ["pylons"]
					["fuel"] = "4864",
					["flare"] = 30,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
		},		
	},
	["C-130"] = {
		["Transport"] = {
			["Default"] = {
				attributes = {},
				weaponType = nil,
				expend = nil,
				day = true,
				night = false,
				adverseWeather = true,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 154.16666666667,
				vAttack = 154.16666666667,
				hCruise = 2572,
				hAttack = 2572,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = 
					{
					}, -- end of ["pylons"]
					["fuel"] = "20830",
					["flare"] = 60,
					["chaff"] = 120,
					["gun"] = 100,
				},
			},
		},
	},
	["UH-1H"] = {
		["Transport"] = {
			["Default"] = {
				attributes = {},
				weaponType = nil,
				expend = nil,
				day = true,
				night = false,
				adverseWeather = true,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 40,
				vAttack = 40,
				hCruise = 500,
				hAttack = 500,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = 
					{
					}, -- end of ["pylons"]
					["fuel"] = "631",
					["flare"] = 60,
					["chaff"] = 0,
					["gun"] = 100,
				},
			},
		},
	},
	["Su-25"] = {
		["Strike"] = {
			["GTA CAS2 PATAB-1M(cluster)*6,R-60M*2"] = {
				minscore = 0.3,
					support = {
						["Escort"] = true,
						["SEAD"] = false,
					},
				attributes = {"soft", "Parked Aircraft"},
				weaponType = "Bombs",
				expend = "All",
				day = true,
				night = false,
				adverseWeather = true,
				range = 150000,
				capability = 1,
				firepower = 1,
				vCruise = 230,
				vAttack = 250,
				hCruise = 2500,
				hAttack = 2000,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = 
				{
				[1] = {
					["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{7AEC222D-C523-425e-B714-719C0D1EB14D}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{7AEC222D-C523-425e-B714-719C0D1EB14D}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{7AEC222D-C523-425e-B714-719C0D1EB14D}",
					["num"] = 4,
				},
				[7] = {
					["CLSID"] = "{7AEC222D-C523-425e-B714-719C0D1EB14D}",
					["num"] = 7,
				},
				[8] = {
					["CLSID"] = "{7AEC222D-C523-425e-B714-719C0D1EB14D}",
					["num"] = 8,
				},
				[9] = {
					["CLSID"] = "{7AEC222D-C523-425e-B714-719C0D1EB14D}",
					["num"] = 9,
				},
				[10] = {
					["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
					["num"] = 10,
				},
				}, -- end of ["pylons"]
                ["fuel"] = "2835",
                ["flare"] = 128,
                ["chaff"] = 128,
                ["gun"] = 100,
				},
			},
			["GTA strike1 S-25L*6,R-60M*2"] = {
				minscore = 0.3,
					support = {
						["Escort"] = true,
						["SEAD"] = false,
					},
				attributes = {"soft", "Parked Aircraft", "Structure"},
				weaponType = "ASM",
				expend = "Auto",
				day = true,
				night = false,
				adverseWeather = true,
				range = 150000,
				capability = 1,
				firepower = 1,
				vCruise = 230,
				vAttack = 250,
				hCruise = 2500,
				hAttack = 2000,
				standoff = 1000,
				tStation = nil,
				LDSD = false,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = 
				{
					[1] = {
					["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
					["num"] = 1,
				},
				[3] = {
					["CLSID"] = "{0180F983-C14A-11d8-9897-000476191836}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{0180F983-C14A-11d8-9897-000476191836}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{0180F983-C14A-11d8-9897-000476191836}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "{0180F983-C14A-11d8-9897-000476191836}",
					["num"] = 6,
				},
				[7] = {
					["CLSID"] = "{0180F983-C14A-11d8-9897-000476191836}",
					["num"] = 7,
				},
				[8] = {
					["CLSID"] = "{0180F983-C14A-11d8-9897-000476191836}",
					["num"] = 8,
				},
				[10] = {
					["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
					["num"] = 10,
				},
				}, -- end of ["pylons"]
                ["fuel"] = "2835",
                ["flare"] = 128,
                ["chaff"] = 128,
                ["gun"] = 100,
				},
			},
			["GTA strike2 Kh-25*4 R-60*2"] = {
				minscore = 0.3,
					support = {
						["Escort"] = true,
						["SEAD"] = false,
					},
				attributes = {"soft", "Parked Aircraft", "Structure"},
				weaponType = "ASM",
				expend = "Auto",
				day = true,
				night = false,
				adverseWeather = true,
				range = 150000,
				capability = 1,
				firepower = 1,
				vCruise = 230,
				vAttack = 250,
				hCruise = 2500,
				hAttack = 2000,
				standoff = 2000,
				tStation = nil,
				LDSD = false,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = 
				{
				[10] = {
					["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
					["num"] = 10,
				},
				[8] = {
					["CLSID"] = "{79D73885-0801-45a9-917F-C90FE1CE3DFC}",
					["num"] = 8,
				},
				[7] = {
					["CLSID"] = "{79D73885-0801-45a9-917F-C90FE1CE3DFC}",
					["num"] = 7,
				},
				[4] = {
					["CLSID"] = "{79D73885-0801-45a9-917F-C90FE1CE3DFC}",
					["num"] = 4,
				},
				[3] = {
					["CLSID"] = "{79D73885-0801-45a9-917F-C90FE1CE3DFC}",
					["num"] = 3,
				},
				[1] = {
					["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
					["num"] = 1,
				},
				}, -- end of ["pylons"]
                ["fuel"] = "2835",
                ["flare"] = 128,
                ["chaff"] = 128,
                ["gun"] = 100,
				},
			},
			["GTA CAS1 S-8KOM*120,R-60M*2"] = {
				minscore = 0.3,
					support = {
						["Escort"] = true,
						["SEAD"] = false,
					},
				attributes = {"soft", "Parked Aircraft", "SAM"},
				weaponType = "Rockets",
				expend = "All",
				day = true,
				night = false,
				adverseWeather = true,
				range = 150000,
				capability = 1,
				firepower = 1,
				vCruise = 230,
				vAttack = 250,
				hCruise = 3500,
				hAttack = 1000,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = 
				{
				[1] = {
					["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{F72F47E5-C83A-4B85-96ED-D3E46671EE9A}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{F72F47E5-C83A-4B85-96ED-D3E46671EE9A}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{F72F47E5-C83A-4B85-96ED-D3E46671EE9A}",
					["num"] = 4,
				},
				[7] = {
					["CLSID"] = "{F72F47E5-C83A-4B85-96ED-D3E46671EE9A}",
					["num"] = 7,
				},
				[8] = {
					["CLSID"] = "{F72F47E5-C83A-4B85-96ED-D3E46671EE9A}",
					["num"] = 8,
				},
				[9] = {
					["CLSID"] = "{F72F47E5-C83A-4B85-96ED-D3E46671EE9A}",
					["num"] = 9,
				},
				[10] = {
					["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
					["num"] = 10,
				},
				}, -- end of ["pylons"]
                ["fuel"] = "2835",
                ["flare"] = 128,
                ["chaff"] = 128,
                ["gun"] = 100,
				},
			},
		},		
	},
	["An-26B"] = {
		["Transport"] = {
			["Default"] = {
				attributes = {},
				weaponType = nil,
				expend = nil,
				day = true,
				night = false,
				adverseWeather = true,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 154.16666666667,
				vAttack = 154.16666666667,
				hCruise = 3500,
				hAttack = 3500,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = 
					{
					}, -- end of ["pylons"]
					["fuel"] = "5500",
					["flare"] = 384,
					["chaff"] = 384,
					["gun"] = 100,
				},
			},
		},
	},
	["Mi-24V"] = {
		["Escort"] = {
			["Escort 4x9M114, 2xUPK-23"] = {
				attributes = {},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 80000,
				capability = 10,
				firepower = 1,
				vCruise = 55,
				vAttack = 55,
				hCruise = 50,
				hAttack = 50,
				standoff = 3000,
				tStation = nil,
				LDSD = false,
				self_escort = true,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
				[1] = {
					["CLSID"] = "{B919B0F4-7C25-455E-9A02-CEA51DB895E3}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{05544F1A-C39C-466b-BC37-5BD1D52E57BB}",
					["num"] = 2,
				},
				[5] = {
					["CLSID"] = "{05544F1A-C39C-466b-BC37-5BD1D52E57BB}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "{B919B0F4-7C25-455E-9A02-CEA51DB895E3}",
					["num"] = 6,
				},
			}, -- end of ["pylons"]
                ["fuel"] = 1551,
                ["flare"] = 192,
                ["chaff"] = 0,
                ["gun"] = 100,
				},
			},
		},
		["Strike"] = {
			["Strike - 8x9M114, 2xUPK-23"] = {
				minscore = 0.3,
				support = {
						["Escort"] = false,
						["SEAD"] = false,
					},
				attributes = {"soft"},
				weaponType = "ASM",
				expend = "Auto",
				day = true,
				night = true,
				adverseWeather = true,
				range = 40000,
				capability = 10,
				firepower = 1,
				vCruise = 55,
				vAttack = 55,
				hCruise = 50,
				hAttack = 50,
				standoff = 4000,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
				[1] = {
					["CLSID"] = "{B919B0F4-7C25-455E-9A02-CEA51DB895E3}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{B919B0F4-7C25-455E-9A02-CEA51DB895E3}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{05544F1A-C39C-466b-BC37-5BD1D52E57BB}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{05544F1A-C39C-466b-BC37-5BD1D52E57BB}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{B919B0F4-7C25-455E-9A02-CEA51DB895E3}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "{B919B0F4-7C25-455E-9A02-CEA51DB895E3}",
					["num"] = 6,
				},
			}, -- end of ["pylons"]
                ["fuel"] = 1551,
                ["flare"] = 192,
                ["chaff"] = 0,
                ["gun"] = 100,
				},
			},
		},		
	},
	["AH-1W"] = {
		["Strike"] = {
			["Strike"] = {
				minscore = 0.3,
				support = {
						["Escort"] = false,
						["SEAD"] = false,
					},
				attributes = {"soft", "Parked Aircraft", "SAM"},
				weaponType = "ASM",
				expend = "Auto",
				day = true,
				night = true,
				adverseWeather = true,
				range = 40000,
				capability = 10,
				firepower = 1,
				vCruise = 55,
				vAttack = 55,
				hCruise = 50,
				hAttack = 50,
				standoff = 4000,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
				[4] = {
					["CLSID"] = "{3EA17AB0-A805-4D9E-8732-4CE00CB00F17}",
					["num"] = 4,
				},
				[1] = {
					["CLSID"] = "{3EA17AB0-A805-4D9E-8732-4CE00CB00F17}",
					["num"] = 1,
				},
			}, -- end of ["pylons"]
                ["fuel"] = 1250,
                ["flare"] = 30,
                ["chaff"] = 30,
                ["gun"] = 100,
				},
			},
		},
	},
	["Mi-8MT"] = {
		["Transport"] = {
			["Default"] = {
				attributes = {},
				weaponType = nil,
				expend = nil,
				day = true,
				night = false,
				adverseWeather = true,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 40,
				vAttack = 40,
				hCruise = 500,
				hAttack = 500,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = {
				[8] = {
					["CLSID"] = "PKT_7_62",
					["num"] = 8,
				},
				[7] = {
					["CLSID"] = "KORD_12_7",
					["num"] = 7,
				},
			}, -- end of ["pylons"]
					["fuel"] = 1929,
                ["flare"] = 128,
                ["chaff"] = 0,
                ["gun"] = 0,
				},
				["AddPropAircraft"] = 
                                        {
                                            ["ExhaustScreen"] = true,
                                            ["CargoHalfdoor"] = true,
                                            ["GunnersAISkill"] = 90,
                                            ["AdditionalArmor"] = true,
                                            ["NS430allow"] = true,
                                        }, -- end of ["AddPropAircraft"]
			},
		},
		["Strike"] = {
			["Strike Rockets"] = {
				minscore = 0.3,
					support = {
						["Escort"] = false,
						["SEAD"] = false,
					},
				attributes = {"soft"},
				weaponType = "Rockets",
				expend = "Auto",
				day = true,
				night = true,
				adverseWeather = true,
				range = 40000,
				capability = 10,
				firepower = 1,
				vCruise = 40,
				vAttack = 55,
				hCruise = 50,
				hAttack = 50,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
				[8] = {
					["CLSID"] = "PKT_7_62",
					["num"] = 8,
				},
				[7] = {
					["CLSID"] = "KORD_12_7",
					["num"] = 7,
				},
				[5] = {
					["CLSID"] = "{6A4B9E69-64FE-439a-9163-3A87FB6A4D81}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "{6A4B9E69-64FE-439a-9163-3A87FB6A4D81}",
					["num"] = 6,
				},
				[2] = {
					["CLSID"] = "{6A4B9E69-64FE-439a-9163-3A87FB6A4D81}",
					["num"] = 2,
				},
				[1] = {
					["CLSID"] = "{6A4B9E69-64FE-439a-9163-3A87FB6A4D81}",
					["num"] = 1,
				},
				[3] = {
					["CLSID"] = "{6A4B9E69-64FE-439a-9163-3A87FB6A4D81}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{6A4B9E69-64FE-439a-9163-3A87FB6A4D81}",
					["num"] = 4,
				},
			}, -- end of ["pylons"]
                ["fuel"] = 1929,
                ["flare"] = 128,
                ["chaff"] = 0,
                ["gun"] = 0,
				},
				["AddPropAircraft"] = 
                                        {
                                            ["ExhaustScreen"] = true,
                                            ["CargoHalfdoor"] = true,
                                            ["GunnersAISkill"] = 90,
                                            ["AdditionalArmor"] = true,
                                            ["NS430allow"] = true,
                                        }, -- end of ["AddPropAircraft"]
			},
		},
	},
	["UH-1H"] = {
		["Transport"] = {
			["Default"] = {
				attributes = {},
				weaponType = nil,
				expend = nil,
				day = true,
				night = false,
				adverseWeather = true,
				range = 500000,
				capability = 10,
				firepower = 1,
				vCruise = 40,
				vAttack = 40,
				hCruise = 500,
				hAttack = 500,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = 
					{
					}, -- end of ["pylons"]
					["fuel"] = "631",
					["flare"] = 60,
					["chaff"] = 0,
					["gun"] = 100,
				},
				["AddPropAircraft"] = 
                    {
                        ["NetCrewControlPriority"] = 1,
                        ["GunnersAISkill"] = 90,
                        ["EngineResource"] = 90,
                        ["ExhaustScreen"] = true,
                    }, -- end of ["AddPropAircraft"]
			},
		},
		["Strike"] = {
			["Strike Gunship"] = {
				minscore = 0.3,
					support = {
						["Escort"] = false,
						["SEAD"] = false,
					},
				attributes = {"soft"},
				weaponType = "Rockets",
				expend = "Auto",
				day = true,
				night = true,
				adverseWeather = true,
				range = 40000,
				capability = 10,
				firepower = 1,
				vCruise = 35,
				vAttack = 45,
				hCruise = 50,
				hAttack = 50,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
				[5] = {
					["CLSID"] = "M261_MK151",
					["num"] = 5,
				},
				[2] = {
					["CLSID"] = "M261_MK151",
					["num"] = 2,
				},
				[1] = {
					["CLSID"] = "M134_L",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "M134_R",
					["num"] = 6,
				},
			}, -- end of ["pylons"]
                ["fuel"] = 631,
                ["flare"] = 60,
                ["chaff"] = 0,
                ["gun"] = 100,
				},
				["AddPropAircraft"] = 
                    {
                        ["NetCrewControlPriority"] = 1,
                        ["GunnersAISkill"] = 90,
                        ["EngineResource"] = 90,
                        ["ExhaustScreen"] = true,
                    }, -- end of ["AddPropAircraft"]
			},
			["Strike Guns"] = {
				minscore = 0.3,
					support = {
						["Escort"] = false,
						["SEAD"] = false,
					},
				attributes = {"soft"},
				weaponType = "Rockets",
				expend = "Auto",
				day = true,
				night = true,
				adverseWeather = true,
				range = 40000,
				capability = 10,
				firepower = 1,
				vCruise = 35,
				vAttack = 45,
				hCruise = 50,
				hAttack = 50,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
				[6] = {
					["CLSID"] = "M134_R",
					["num"] = 6,
				},
				[1] = {
					["CLSID"] = "M134_L",
					["num"] = 1,
				},
				[3] = {
					["CLSID"] = "M60_SIDE_L",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "M60_SIDE_R",
					["num"] = 4,
				},
			}, -- end of ["pylons"]
                ["fuel"] = 631,
                ["flare"] = 60,
                ["chaff"] = 0,
                ["gun"] = 100,
				},
				["AddPropAircraft"] = 
                    {
                        ["NetCrewControlPriority"] = 1,
                        ["GunnersAISkill"] = 90,
                        ["EngineResource"] = 90,
                        ["ExhaustScreen"] = true,
                    }, -- end of ["AddPropAircraft"]
			},
			["Strike Rockets"] = {
				minscore = 0.3,
					support = {
						["Escort"] = false,
						["SEAD"] = false,
					},
				attributes = {"soft"},
				weaponType = "Rockets",
				expend = "Auto",
				day = true,
				night = true,
				adverseWeather = true,
				range = 40000,
				capability = 10,
				firepower = 1,
				vCruise = 35,
				vAttack = 45,
				hCruise = 50,
				hAttack = 50,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
				[5] = {
					["CLSID"] = "M261_MK151",
					["num"] = 5,
				},
				[2] = {
					["CLSID"] = "M261_MK151",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "M60_SIDE_L",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "M60_SIDE_R",
					["num"] = 4,
				},
			}, -- end of ["pylons"]
                ["fuel"] = 631,
                ["flare"] = 60,
                ["chaff"] = 0,
                ["gun"] = 100,
				},
				["AddPropAircraft"] = 
                    {
                        ["NetCrewControlPriority"] = 1,
                        ["GunnersAISkill"] = 90,
                        ["EngineResource"] = 90,
                        ["ExhaustScreen"] = true,
                    }, -- end of ["AddPropAircraft"]
			},
		},
	},
	["Il-76MD"] = {
		["Transport"] = {
			["Default"] = {
				attributes = {},
				weaponType = nil,
				expend = nil,
				day = true,
				night = false,
				adverseWeather = true,
				range = 500000,
				capability = 10,
				firepower = 1,
				vCruise = 154.16666666667,
				vAttack = 154.16666666667,
				hCruise = 3500,
				hAttack = 3500,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = 
					{
					}, -- end of ["pylons"]
					["fuel"] = 40000,
                    ["flare"] = 96,
                    ["chaff"] = 96,
                    ["gun"] = 100,
				},
			},
		},
	},	
}
	